/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.lib.HexBlocks;
import com.mojang.datafixers.util.Pair;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2428;
import net.minecraft.class_2442;
import net.minecraft.class_2457;
import net.minecraft.class_2462;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2747;
import net.minecraft.class_2766;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_5251;

public class ScryingLensOverlays {
    public static void addScryingLensStuff() {
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.method_26204() instanceof BlockAbstractImpetus, (lines, state, pos, observer, world, direction) -> {
            class_2586 patt1640$temp = world.method_8321(pos);
            if (patt1640$temp instanceof BlockEntityAbstractImpetus) {
                BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)patt1640$temp;
                beai.applyScryingLensOverlay(lines, state, pos, observer, world, direction);
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10179, (lines, state, pos, observer, world, direction) -> {
            int note = (Integer)state.method_11654((class_2769)class_2428.field_11324);
            float rCol = Math.max(0.0f, class_3532.method_15374((float)(((float)note / 24.0f + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float gCol = Math.max(0.0f, class_3532.method_15374((float)(((float)note / 24.0f + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float bCol = Math.max(0.0f, class_3532.method_15374((float)(((float)note / 24.0f + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            int noteColor = 0xFF000000 | class_3532.method_15353((float)rCol, (float)gCol, (float)bCol);
            class_2766 instrument = (class_2766)state.method_11654((class_2769)class_2428.field_11325);
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8623), (Object)class_2561.method_43470((String)String.valueOf(instrument.ordinal())).method_27694(ScryingLensOverlays.color(ScryingLensOverlays.instrumentColor(instrument)))));
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8643), (Object)class_2561.method_43470((String)String.valueOf(note)).method_27694(ScryingLensOverlays.color(noteColor))));
        });
        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_BOOKSHELF, (lines, state, pos, observer, world, direction) -> {
            BlockEntityAkashicBookshelf tile;
            class_2487 iotaTag;
            class_2586 patt3143$temp = world.method_8321(pos);
            if (patt3143$temp instanceof BlockEntityAkashicBookshelf && (iotaTag = (tile = (BlockEntityAkashicBookshelf)patt3143$temp).getIotaTag()) != null) {
                class_2561 display = IotaType.getDisplay(iotaTag);
                lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8529), (Object)display));
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10377, (lines, state, pos, observer, world, direction) -> {
            int comparatorValue = state.method_26176(world, pos);
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8725), (Object)class_2561.method_43470((String)(comparatorValue == -1 ? "" : String.valueOf(comparatorValue))).method_27694(ScryingLensOverlays.redstoneColor(comparatorValue))));
            boolean compare = state.method_11654((class_2769)class_2286.field_10789) == class_2747.field_12576;
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8530), (Object)class_2561.method_43470((String)(compare ? ">=" : "-")).method_27694(ScryingLensOverlays.redstoneColor(compare ? 0 : 15))));
        });
        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10425, (lines, state, pos, observer, world, direction) -> {
            int power = ScryingLensOverlays.getPoweredRailStrength(world, pos, state);
            lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8848), (Object)class_2561.method_43470((String)String.valueOf(power)).method_27694(ScryingLensOverlays.redstoneColor(power, 9))));
        });
        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10450, (lines, state, pos, observer, world, direction) -> lines.add(new Pair((Object)new class_1799((class_1935)class_1802.field_8557), (Object)class_2561.method_43470((String)String.valueOf(state.method_11654((class_2769)class_2462.field_11451))).method_27692(class_124.field_1054))));
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.method_26219() && !state.method_27852(class_2246.field_10377), (lines, state, pos, observer, world, direction) -> {
            int signalStrength = 0;
            if (state.method_26204() instanceof class_2457) {
                signalStrength = (Integer)state.method_11654((class_2769)class_2457.field_11432);
            } else {
                for (class_2350 dir : class_2350.values()) {
                    signalStrength = Math.max(signalStrength, state.method_26195((class_1922)world, pos, dir));
                }
            }
            lines.add(0, new Pair((Object)new class_1799((class_1935)class_1802.field_8725), (Object)class_2561.method_43470((String)String.valueOf(signalStrength)).method_27694(ScryingLensOverlays.redstoneColor(signalStrength))));
        });
    }

    private static int getPoweredRailStrength(class_1937 level, class_2338 pos, class_2680 state) {
        if (level.method_49803(pos)) {
            return 9;
        }
        int positiveValue = ScryingLensOverlays.findPoweredRailSignal(level, pos, state, true, 0);
        int negativeValue = ScryingLensOverlays.findPoweredRailSignal(level, pos, state, false, 0);
        return Math.max(positiveValue, negativeValue);
    }

    private static int findPoweredRailSignal(class_1937 level, class_2338 pos, class_2680 state, boolean travelPositive, int depth) {
        if (depth >= 8) {
            return 0;
        }
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        boolean descending = true;
        class_2768 shape = (class_2768)state.method_11654((class_2769)class_2442.field_11365);
        switch (shape) {
            case field_12665: {
                if (travelPositive) {
                    ++z;
                    break;
                }
                --z;
                break;
            }
            case field_12674: {
                if (travelPositive) {
                    --x;
                    break;
                }
                ++x;
                break;
            }
            case field_12667: {
                if (travelPositive) {
                    --x;
                } else {
                    ++x;
                    ++y;
                    descending = false;
                }
                shape = class_2768.field_12674;
                break;
            }
            case field_12666: {
                if (travelPositive) {
                    --x;
                    ++y;
                    descending = false;
                } else {
                    ++x;
                }
                shape = class_2768.field_12674;
                break;
            }
            case field_12670: {
                if (travelPositive) {
                    ++z;
                } else {
                    --z;
                    ++y;
                    descending = false;
                }
                shape = class_2768.field_12665;
                break;
            }
            case field_12668: {
                if (travelPositive) {
                    ++z;
                    ++y;
                    descending = false;
                } else {
                    --z;
                }
                shape = class_2768.field_12665;
            }
        }
        int power = ScryingLensOverlays.getPowerFromRail(level, new class_2338(x, y, z), travelPositive, depth, shape);
        if (power > 0) {
            return power;
        }
        if (descending) {
            return ScryingLensOverlays.getPowerFromRail(level, new class_2338(x, y - 1, z), travelPositive, depth, shape);
        }
        return 0;
    }

    private static UnaryOperator<class_2583> color(int color) {
        return style -> style.method_27703(class_5251.method_27717((int)color));
    }

    private static UnaryOperator<class_2583> redstoneColor(int power) {
        return ScryingLensOverlays.redstoneColor(power, 15);
    }

    private static UnaryOperator<class_2583> redstoneColor(int power, int max) {
        return ScryingLensOverlays.color(class_2457.method_10487((int)class_3532.method_15340((int)(power * max / 15), (int)0, (int)15)));
    }

    private static int instrumentColor(class_2766 instrument) {
        return switch (instrument) {
            case class_2766.field_12653 -> class_3620.field_16023.field_16011;
            case class_2766.field_12643, class_2766.field_12655, class_2766.field_18289 -> class_3620.field_15986.field_16011;
            case class_2766.field_12645 -> class_3620.field_16025.field_16011;
            case class_2766.field_12651 -> class_3620.field_15996.field_16011;
            case class_2766.field_12650 -> class_3620.field_15976.field_16011;
            case class_2766.field_12644 -> class_3620.field_15994.field_16011;
            case class_2766.field_12654 -> class_3620.field_15979.field_16011;
            case class_2766.field_12647 -> class_3620.field_16016.field_16011;
            case class_2766.field_18284 -> class_3620.field_16005.field_16011;
            case class_2766.field_18285 -> class_3620.field_15977.field_16011;
            case class_2766.field_18286 -> class_3620.field_15987.field_16011;
            case class_2766.field_18287 -> class_3620.field_16001.field_16011;
            case class_2766.field_18288 -> class_3620.field_16010.field_16011;
            default -> -1;
        };
    }

    private static int getPowerFromRail(class_1937 level, class_2338 pos, boolean travelPositive, int depth, class_2768 shape) {
        class_2680 otherState = level.method_8320(pos);
        if (!otherState.method_27852(class_2246.field_10425)) {
            return 0;
        }
        class_2768 otherShape = (class_2768)otherState.method_11654((class_2769)class_2442.field_11365);
        if (shape == class_2768.field_12674 && (otherShape == class_2768.field_12665 || otherShape == class_2768.field_12670 || otherShape == class_2768.field_12668)) {
            return 0;
        }
        if (shape == class_2768.field_12665 && (otherShape == class_2768.field_12674 || otherShape == class_2768.field_12667 || otherShape == class_2768.field_12666)) {
            return 0;
        }
        if (((Boolean)otherState.method_11654((class_2769)class_2442.field_11364)).booleanValue()) {
            return level.method_49803(pos) ? 8 - depth : ScryingLensOverlays.findPoweredRailSignal(level, pos, otherState, travelPositive, depth + 1);
        }
        return 0;
    }
}

